/**
 * Object wrapper.
 */
class UIRegistry {
	/**
	 * Class constructor.
	 *
	 * @param 	mixed  An optional object to hold.
	 */
	constructor(obj) {
		this.init(obj);
	}

	/**
	 * Properties getter.
	 *
	 * @param 	string  key  The object key.
	 * @param 	mixed   def  The default value to return when missing.
	 *
	 * @return 	mixed   The object value, or the default one.
	 */
	get(key, def) {
		if (this.obj.hasOwnProperty(key)) {
			return this.obj[key];
		}

		if (def === undefined) {
			return null;
		}

		return def;
	}

	/**
	 * Properties setter.
	 *
	 * @param 	string  key  The object key.
	 * @param 	mixed   val  The object value.
	 *
	 * @return 	self    This object to support chaining.
	 */
	set(key, val) {
		this.obj[key] = val;

		return this;
	}

	/**
	 * Set up the registry.
	 *
	 * @param 	mixed  obj  The object to hold.
	 *
	 * @return 	self   This object to support chaining.
	 */
	init(obj) {
		if (obj === undefined) {
			obj = {};
		}

		this.obj = obj;

		return this;
	}

	/**
	 * Returns the plain object.
	 *
	 * @return 	object
	 */
	getObject() {
		return this.obj;
	}
}

// export for external usage
module.exports = UIRegistry;
